// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for viewing One Time Pad Key Files.
//...............................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	BOOL				bIsWin9x;
extern	HINSTANCE			hInst;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpOtpKeyIcon;
extern	LPCTSTR				lpszStopSign;
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	HWND				hMainWindow;
extern	BOOL				bCancelOperation;
extern	HWND				hViewWindow;
extern	BOOL				bViewWindowDisplayed;
extern	BOOL				bScrollWnd;
extern	BOOL				bSizeWnd;
extern	DWORD				dwOldHelpNumber;
extern	int					xClient;
extern	int					yClient;
extern	int					xClientMax;
extern	int					xChar;
extern	int					yChar;
extern	int					xPos;
extern	int					yPos;
extern	int					xMax;
extern	int					yMax;
extern	int					xInc;
extern	int					yInc;
extern	int					iTotalLines;
extern	RECT				BitMapRect;
extern	SCROLLINFO			sci;
extern	PAINTSTRUCT			ps;
extern	HDC					hDC;
extern	HDC					hCompatDC;
extern	HBITMAP				hbm;
extern	TEXTMETRIC			tm;
extern	NUMBERFMT			nFormatInfo;
extern	LPTSTR				lpMyCmdLine;
extern	LPTSTR				lpMyCmdFile;
extern	UINT				uiWheelScrollLines;
extern	int					iDelta;
extern	CONFIG				cfg;

// A couple of local macros.
//..........................
#define Col(x) ((x + RtMargin) * xChar)
#define Line(y) (y * yChar)

// Variables for centering the information in a window.
//.....................................................
int				RtMargin;
int				iMaxWidth;

// Local variables.
//.................
LPCTSTR			lpszViewOtpFile = "ViewOtpFile";
LPBYTE			lpOtpFileBuffer = 0;
TCHAR			szOtpFile[MAX_PATH];
LPTSTR			lpszLineFormat = "%s   %s   %s   %s";
HANDLE			hOtpEvent;
HANDLE			hOtpOpen;

// Register the window class to use for viewing otp key files.
//............................................................
BOOL RegisterOtpViewWindow()
{
	WNDCLASS	wc;

	wc.style		 = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc	 = (WNDPROC)ViewOtpProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst,lpOtpKeyIcon);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;              
    wc.lpszClassName = lpszViewOtpFile;
	
	if (bIsWin9x)
	{
		if (!RegisterWin95(&wc))
		{
			return(FALSE);
		}
	}
	else if (!RegisterClass(&wc))
	{
		return(FALSE);
	}
	return(TRUE);
}

// Window procedure for processing message for view otp file window.
//..................................................................
LRESULT CALLBACK ViewOtpProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_CREATE:
		{
			TCHAR			szTempFileName[MAX_PATH];
			HMENU			hViewWinMenu;
			MENUITEMINFO	mii;
			
			ShowScrollBar(hWnd,SB_BOTH,TRUE);

			// Disable the move menu item on the window menu.
			//...............................................
			hViewWinMenu = GetSystemMenu(hWnd,FALSE);

			ZeroMemory(&mii,sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_ID | MIIM_STATE;
			mii.fState = MFS_GRAYED;
			mii.wID = -10;
			SetMenuItemInfo(hViewWinMenu,SC_MOVE,FALSE,&mii);

			// Set the title for the window. Use the name of 
			// the one time pad key file.
			//..............................................
			CopyMemory(szTempFileName,szOtpFile,MAX_PATH);
			PathStripPath(szTempFileName);
			SetWindowText(hWnd,szTempFileName);

			// Setup the default DC for our window.
			//.....................................
			hDC = GetDC(hWnd);
			if (!hDC)
			{
				goto ErrorCreate;
			}
			// Create a compatable DC and bitmap to hold at least 
			// 434 lines of text.
			//...................................................
			hCompatDC = CreateCompatibleDC(hDC);
			if (!hCompatDC)
			{
			  ErrorCreate:

				if (hCompatDC)
				{
					DeleteDC(hCompatDC);
					hCompatDC = 0;
				}
				if (hbm)
				{
					DeleteObject(hbm);
					hbm = 0;
				}
				return(-1);
			}
			// Setup our fixed pitch font to use.
			//...................................
			SelectObject(hCompatDC,GetStockObject(ANSI_FIXED_FONT));
			GetTextMetrics(hCompatDC,&tm);
			yChar = tm.tmHeight + tm.tmExternalLeading;
			xChar = tm.tmMaxCharWidth;

			RtMargin = 0;

			if (!cfg.dwLeftAlign)
			{
				// Get centering information for the window.
				//..........................................
				iMaxWidth = GetSystemMetrics(SM_CXMAXIMIZED);

				RtMargin = (((iMaxWidth / xChar) - 78) / 2) -2;

				if (RtMargin < 0)
				{
					RtMargin = 0;
				}
			}
			// Arbitary max width of client area.
			//...................................
			xClientMax = ((78 + RtMargin) * xChar);

			// Set the mapping mode.
			//......................
			SetMapMode(hCompatDC,MM_TEXT);

			// Setup a rect for the bitmap.
			//.............................
			BitMapRect.left = 0;
			BitMapRect.top = 0;
			BitMapRect.right = xClientMax;
			BitMapRect.bottom = 436 * yChar;

			hbm = CreateCompatibleBitmap(hDC,BitMapRect.right,BitMapRect.bottom);
			if (!hbm)
			{
				goto ErrorCreate;
			}
			// Select the bitmap into the compatible DC.
			//..........................................
			SelectObject(hCompatDC,hbm);

			// Setup the otp key file to view.
			//................................
			SetupOtpKeyFileToView();
			SetFocus(hWnd);
			bViewWindowDisplayed = TRUE;
		}
		break;

		case WM_SYSCOLORCHANGE:
		{
			SetupOtpKeyFileToView(hWnd);
			bSizeWnd = TRUE;
			InvalidateRect(hWnd,NULL,FALSE);
		}
		break;

		case WM_PAINT:
		{
			PRECT	prect;
			BOOL	bHaveUpdate;

			bHaveUpdate = GetUpdateRect(hWnd,NULL,FALSE);

			BeginPaint(hWnd,&ps);

			// Draw the lines of text from the bitmap.
			//........................................
			if (bSizeWnd)
			{
				BitBlt(hDC,ps.rcPaint.left,ps.rcPaint.top,xClient,yClient,
					   hCompatDC,xPos * xInc,yPos * yInc,SRCCOPY);
			}
			if (bScrollWnd)
			{
				prect = &ps.rcPaint;

				BitBlt(ps.hdc,prect->left,prect->top,
					   prect->right - prect->left,
					   prect->bottom - prect->top,
					   hCompatDC,prect->left + (xPos * xChar),
					   prect->top + (yPos * yChar),SRCCOPY);
			}
			if (!bScrollWnd && !bSizeWnd && bHaveUpdate)
			{
				prect = &ps.rcPaint;

				BitBlt(ps.hdc,prect->left,prect->top,
					   prect->right - prect->left,
					   prect->bottom - prect->top,
					   hCompatDC,prect->left + (xPos * xChar),
					   prect->top + (yPos * yChar),SRCCOPY);
			}
			bSizeWnd = FALSE;
			bScrollWnd = FALSE;
			EndPaint(hWnd,&ps);
			SetFocus(hWnd);
		}
		break;

		case WM_SIZE:
		{
			// Retrieve the dminension of the client area.
			//............................................
			yClient = HIWORD(lParam);
			xClient = LOWORD(lParam);

			xPos = 0;
			yPos = 0;

			// Determine the maximum vertical scrolling position.
			// The two is added for extra space below the lines
			// of text and the status bar.
			//...................................................
			yMax = max(0,iTotalLines + 2 - (yClient/yChar));

			// Make sure the current vertical scrolling position
			// does not exceed the maximum.
			//..................................................
			yPos = min(yPos,yMax);

			if ((yClient/yChar) < iTotalLines)
			{
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
				sci.nMin = 0;
				sci.nMax = iTotalLines - 1;
				sci.nPage = (yClient/yChar) + 1;
				sci.nPos = yPos;

				EnableScrollBar(hWnd,SB_VERT,ESB_ENABLE_BOTH);
				SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
			}
			else
			{
				EnableScrollBar(hWnd,SB_VERT,ESB_DISABLE_BOTH);
			}
			// Determine the maximum horizontal scrolling position.
			//.....................................................
			xMax = max(0,((xClientMax - xClient)/xChar));

			// Make sure the current horizontal scrolling position
			// does not exceed the maximum.
			//....................................................
			xPos = min(xPos,xMax);
			
			if (xMax < (78 + RtMargin))
			{
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
				sci.nMin = 0;
				sci.nMax = 78 + RtMargin - 1;
				sci.nPage = (xClient / xChar) + 1;
				sci.nPos = xPos;

				EnableScrollBar(hWnd,SB_HORZ,ESB_ENABLE_BOTH);
				SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);
			}
			else
			{
				EnableScrollBar(hWnd,SB_HORZ,ESB_DISABLE_BOTH);
			}
			// Redisplay the otp key file.
			//............................
			bSizeWnd = TRUE;
			InvalidateRect(hWnd,NULL,FALSE);
		}
		break;

		case WM_CLOSE:
		{
			DestroyWindow(hWnd);
		}
		break;

		case WM_DESTROY:
		{
			if (hCompatDC)
			{
				DeleteDC(hCompatDC);
				hCompatDC = 0;
			}
			if (hbm)
			{
				DeleteObject(hbm);
				hbm = 0;
			}
			// Notify the view otp file procedure it can continue.
			//....................................................
			SetEvent(hOtpEvent);

			bViewWindowDisplayed = FALSE;
		}
		break;

		case WM_HSCROLL:
		{
			switch (LOWORD(wParam))
			{
				// We clicked the shaft left of the scroll box.
				//.............................................
				case SB_PAGELEFT:
				{
					xInc = -8;
					break;
				}
				// We clicked the shaft right of the scroll box.
				//..............................................
				case SB_PAGERIGHT:
				{
					xInc = 8;
					break;
				}
				// We clicked the left arrow.
				//...........................
				case SB_LINELEFT:
				{
					xInc = -1;
					break;
				}
				// We clicked the right arrow.
				//............................
				case SB_LINERIGHT:
				{
					xInc = 1;
					break;
				}
				// We dragged the scroll bar.
				//...........................
				case SB_THUMBTRACK:
				{
					xInc = HIWORD(wParam) - xPos;
					break;
				}
				default:
					xInc = 0;
			}
			// If applying the horizontal scrolling increment does not
			// take the scrolling position out of the scrolling range,
			// increment the scrolling position, adjust the position
			// of the scroll box, and update the window.
			//........................................................
			if (xInc = max(-xPos, min(xInc, xMax-xPos)))
			{
				bScrollWnd = TRUE;
				xPos += xInc;
				ScrollWindowEx(hWnd,-xChar * xInc,0,NULL,NULL,
							   NULL,NULL,SW_INVALIDATE | SW_ERASE);
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS;
				sci.nPos = xPos;
				SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);
				UpdateWindow(hWnd);
			}
			break;
		}

		case WM_MOUSEWHEEL:
		{
			int			iIncrements;

			if (uiWheelScrollLines != 0)
			{
				// Default value.
				//...............
				yInc = 0;

				if (wParam & (MK_SHIFT | MK_CONTROL))
				{	
					return(DefWindowProc(hWnd,uMsg,wParam,lParam));
				}
				iDelta -= (SHORT) HIWORD(wParam);
				iIncrements = iDelta / WHEEL_DELTA;
				iDelta %= WHEEL_DELTA;

				if (iIncrements != 0)
				{
					if (uiWheelScrollLines == WHEEL_PAGESCROLL)
					{
						if (iIncrements < 0)
						{
							// PageUp.
							//.......
							yInc = min(-1,-yClient / yChar);
						}
						else
						{
							yInc = max(1,yClient / yChar);
						}
					}
					else
					{
						yInc = iIncrements * uiWheelScrollLines;
					}
				}
				// If applying the vertical scrolling increment does not
				// take the scrolling position out of the scrolling range,
				// increment the scrolling position, adjust the position
				// of the scroll box, and update the window.
				//.......................................................
				if (yInc = max(-yPos, min(yInc, yMax - yPos)))
				{
					bScrollWnd = TRUE;
	
					yPos += yInc;
				
					// Only scroll the window if yInc is less than yClient.
					// If greater or equal to yClient invalidate the whole
					// rectangle and redraw it.
					//....................................................
					if (abs(yInc) < yClient)
					{
						ScrollWindowEx(hWnd,0,-yChar * yInc,NULL,NULL,
									   NULL,NULL,SW_INVALIDATE | SW_ERASE);
					}
					else
					{
						InvalidateRect(hWnd,NULL,TRUE);
					}

					sci.cbSize = sizeof(SCROLLINFO);
					sci.fMask = SIF_POS;
					sci.nPos = yPos;
					SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
					UpdateWindow(hWnd);
				}
			}
		}
		break;
	
		case WM_VSCROLL:
		{
			switch(LOWORD(wParam))
			{
				// We clicked the shaft above the scroll box.
				//...........................................
				case SB_PAGEUP:
				{
					yInc = min(-1,-yClient / yChar);
					break;
				}
				// We clicked the shaft below the scroll box.
				//...........................................
				case SB_PAGEDOWN:
				{
					yInc = max(1,yClient / yChar);
					break;
				}
				// We clicked the top arrow.
				//..........................
				case SB_LINEUP:
				{
					yInc = -1;
					break;
				}
				// We clicked the bottom arrow.
				//.............................
				case SB_LINEDOWN:
				{
					yInc = 1;
					break;
				}
				// We dragged the scroll box.
				//...........................
				case SB_THUMBTRACK:
				{
					yInc = HIWORD(wParam) - yPos;
					break;
				}
				// We used the home key to go to the top.
				//.......................................
				case SB_TOP:
				{
					yInc = -yMax;
					break;
				}
				// We used the end key to go to the bottom.
				//.........................................
				case SB_BOTTOM:
				{
					yInc = yMax;
					break;
				}

				default:
					yInc = 0;
			}
			// If applying the vertical scrolling increment does not
			// take the scrolling position out of the scrolling range,
			// increment the scrolling position, adjust the position
			// of the scroll box, and update the window.
			//.......................................................
			if (yInc = max(-yPos, min(yInc, yMax - yPos)))
			{
				bScrollWnd = TRUE;

				yPos += yInc;
				
				// Only scroll the window if yInc is less than yClient.
				// If greater or equal to yClient invalidate the whole
				// rectangle and redraw it.
				//....................................................
				if (abs(yInc) < yClient)
				{
					ScrollWindowEx(hWnd,0,-yChar * yInc,NULL,NULL,
								   NULL,NULL,SW_INVALIDATE | SW_ERASE);
				}
				else
				{
					InvalidateRect(hWnd,NULL,TRUE);
				}

				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS;
				sci.nPos = yPos;
				SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
				UpdateWindow(hWnd);
			}
			break;
		}
		// Capture the keyboard keys for manipulating the scroll bars.
		//............................................................
		case WM_KEYDOWN:
		{
			WORD	wScrollAction = 0xFFFF;
			UINT	ScrollMsg = WM_VSCROLL;

			switch(wParam)
			{
				case VK_UP:
				{
					wScrollAction = SB_LINEUP;
					break;
				}
				case VK_DOWN:
				{
					wScrollAction = SB_LINEDOWN;
					break;
				}
				case VK_PRIOR:
				{
					wScrollAction = SB_PAGEUP;
					break;
				}
				case VK_NEXT:
				{
					wScrollAction = SB_PAGEDOWN;
					break;
				}
				case VK_HOME:
				{
					wScrollAction = SB_TOP;
					break;
				}
				case VK_END:
				{
					wScrollAction = SB_BOTTOM;
					break;
				}
				// Take care of the horizontal scroll bar.
				//........................................
				case VK_LEFT:
				{
					wScrollAction = SB_LINELEFT;
					ScrollMsg = WM_HSCROLL;
					break;
				}
				case VK_RIGHT:
				{
					wScrollAction = SB_LINERIGHT;
					ScrollMsg = WM_HSCROLL;
					break;
				}
				case VK_ESCAPE:
				{
					DestroyWindow(hWnd);
				}
				break;
			}
			if (wScrollAction != -1)
			{
				SendMessage(hWnd,ScrollMsg,MAKELONG(wScrollAction,0),0L);
			}
			break;
		}		
        default:
			return(DefWindowProc(hWnd, uMsg, wParam, lParam));
	}
	return(0L);
}

// View otp key files.
//....................
VOID ViewOneTimePadFiles()
{
	OPENFILENAME	ofn;
	HANDLE			hOtpFile = 0;
	DWORD			dwBytesRead;
	BOOL			bResult;
	RECT			rect;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	dwOldHelpNumber = ChangeHelpTopic(IDH_VIEWOTPFILES);

	// See if we have a command line file to process.
	//...............................................
   	if (lpMyCmdLine)
	{
		ZeroMemory(&szOtpFile,sizeof(szOtpFile));
		CopyMemory(&szOtpFile,lpMyCmdFile,MAX_PATH);
		lpMyCmdLine = 0;

		// Make sure we have a valid key file.
		//....................................
		hOtpFile =  IsValidOTPKeyFile((LPTSTR)&szOtpFile);
		
		if (!hOtpFile)
		{
			goto ViewOtpEnd;
		}
	}
	else
	{
		// Initialize the OPENFILENAME structure.
		//.......................................
		InitializeOFN(&ofn,SAVE_OTPKEYFILES);

		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = szOtpFile;
		ofn.nMaxFile = sizeof(szOtpFile);
		ofn.hwndOwner = hMainWindow;
		ofn.lpstrFilter = TEXT("One Time Pad Key Files [.otp]\0*.otp\0All Files [*.*]\0*.*\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select a One Time Pad Key File to View");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY);
		ofn.lpstrDefExt = TEXT("otp");
		ofn.lpfnHook = MyOFNHookProc;

		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		// Get the one time pad key file to view.
		//.......................................
		while(TRUE)
		{
			ZeroMemory(szOtpFile,sizeof(szOtpFile));

			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto ViewOtpEnd;
			}
			SaveDirName((LPBYTE)&szOtpFile,SAVE_OTPKEYFILES | SAVE_SOURCE,TRUE);

			// Make sure we have a valid key file.
			//....................................
			hOtpFile =  IsValidOTPKeyFile((LPTSTR)&szOtpFile);
		
			if (hOtpFile)
			{
				break;
			}
		}
	}
	EmptyTheMessageQue();

	// Allocate the memory for the otp file buffer.
	//.............................................
	lpOtpFileBuffer = AllocateMemory(Goal * 4);
	if (!lpOtpFileBuffer)
	{
		goto ViewOtpEnd;
	}
	// Read the file into memory.
	//...........................
	bResult = ReadMyFile((LPTSTR)&szOtpFile,hOtpFile,lpOtpFileBuffer,
						(Goal * 4),&dwBytesRead,NULL);
	if (!bResult)
	{
		goto ViewOtpEnd;
	}
	// Create our event for the view senders and recipients
	// window.
	//..................................................
	hOtpEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("OtpEvent"));
	if (!hOtpEvent)
	{
		ErrorProcedure(TEXT("OtpEvent"),IDS_CREATEEVENT,MB_OK);
		goto ViewOtpEnd;
	}
	// Create the view window for the otp key file.
	//.............................................
	GetClientRect(hMainWindow,&rect);

	// Create the window for viewing the public keys.
	//...............................................
	hViewWindow = CreateWindowEx(WS_EX_CLIENTEDGE,lpszViewOtpFile,
								 lpszNullString,WS_CAPTION | WS_CHILD |
								 WS_SYSMENU | WS_HSCROLL | WS_VSCROLL | 
								 WS_VISIBLE | WS_CLIPCHILDREN,rect.left,
								 rect.top+37,rect.right,rect.bottom-59,
								 hMainWindow,NULL,hInst,NULL);
	if (!hViewWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto ViewOtpEnd;
	}
	// Open the event object.
	//.......................
	hOtpOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("OtpEvent"));
	if (!hOtpOpen)
	{
		DestroyWindow(hViewWindow);
		goto ViewOtpEnd;
	}
	// We have to wait for the Edit Event to become signaled 
	// before we can return.
	//......................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hOtpEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}

	ViewOtpEnd:

	if (hOtpOpen)
	{
		CloseHandle(hOtpOpen);
		hOtpOpen = 0;
	}
	if (hOtpEvent)
	{
		CloseHandle(hOtpEvent);
		hOtpEvent = 0;
	}
	if (hOtpFile)
	{
		CloseMyHandle((LPTSTR)&szOtpFile,hOtpFile);
		hOtpFile = 0;
	}
	if (lpOtpFileBuffer)
	{
		ZeroMemory(lpOtpFileBuffer,(Goal * 4));
		DeallocateMemory(lpOtpFileBuffer);
		lpOtpFileBuffer = 0;
	}
	ChangeHelpTopic(dwOldHelpNumber);
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;
}

// Setup an otp key file to view.
//...............................
VOID SetupOtpKeyFileToView()
{
	int				iGoal = Goal;
	int				iCol;
	int				iLength;
	DWORD			dwCount = 1;
	DWORD			dwNumber1;
	DWORD			dwNumber2;
	DWORD			dwNumber3;
	DWORD			dwNumber4;
	DWORD			dwGroup = 0;
	LPBYTE			lpOtpBufferDup;
	TCHAR			szCount[16];
	TCHAR			szNumber1[16];
	TCHAR			szNumber2[16];
	TCHAR			szNumber3[16];
	TCHAR			szNumber4[16];
	TCHAR			szOutBuffer[96];

	// Fill the rectangle with the window background color.
	//.....................................................
	FillRect(hCompatDC,&BitMapRect,(HBRUSH)(COLOR_WINDOW+1));
	SelectObject(hCompatDC,GetStockObject(NULL_BRUSH));
	SetBkColor(hCompatDC,GetSysColor(COLOR_WINDOW));

	lpOtpBufferDup = lpOtpFileBuffer;
	iTotalLines = 1;

	while(iGoal > 0)
	{
		// Retrieve 4 numbers.
		//....................
		__asm
		{
			mov		esi,lpOtpBufferDup
			lodsd
			mov		dwNumber1,eax
			lodsd
			mov		dwNumber2,eax
			lodsd
			mov		dwNumber3,eax
			mov		eax,0
			cmp		iGoal,3
			jle		L1
			lodsd
		L1:	mov		dwNumber4,eax
			mov		lpOtpBufferDup,esi
		}
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),TEXT("%4.4d"),dwCount);
		GetNumberFormat(LOCALE_USER_DEFAULT,0,szOutBuffer,&nFormatInfo,
						szCount,sizeof(szCount));
		SetTextColor(hCompatDC,RGB(0,128,0));
		
		// Determine the column to print the number on.
		//.............................................
		iLength = lstrlen(szCount);
		if (iLength == 1)
		{
			iCol = 8;
		}
		else if (iLength == 2)
		{
			iCol = 7;
		}
		else if (iLength == 3)
		{
			iCol = 6;
		}
		else
		{
			iCol = 4;
		}
		TextOut(hCompatDC,Col(iCol),Line(iTotalLines),szCount,lstrlen(szCount));

		// Now do the four numbers in the row.
		//....................................
		SetTextColor(hCompatDC,RGB(0,0,255));
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),TEXT("%.10u"),dwNumber1);
		GetNumberFormat(LOCALE_USER_DEFAULT,0,szOutBuffer,&nFormatInfo,szNumber1,
					    sizeof(szNumber1));
		CheckOutTheNumber((LPBYTE)&szNumber1);
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),TEXT("%.10u"),dwNumber2);
		GetNumberFormat(LOCALE_USER_DEFAULT,0,szOutBuffer,&nFormatInfo,
						szNumber2,sizeof(szNumber2));
		CheckOutTheNumber((LPBYTE)&szNumber2);
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),TEXT("%.10u"),dwNumber3);
		GetNumberFormat(LOCALE_USER_DEFAULT,0,szOutBuffer,&nFormatInfo,
						szNumber3,sizeof(szNumber3));
		CheckOutTheNumber((LPBYTE)&szNumber3);
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),TEXT("%.10u"),dwNumber4);
		GetNumberFormat(LOCALE_USER_DEFAULT,0,szOutBuffer,&nFormatInfo,
						szNumber4,sizeof(szNumber4));
		CheckOutTheNumber((LPBYTE)&szNumber4);
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)lpszLineFormat,
						szNumber1,szNumber2,szNumber3,szNumber4);
		TextOut(hCompatDC,Col(13),Line(iTotalLines),szOutBuffer,lstrlen(szOutBuffer));
		dwGroup++;
		if (dwGroup == 3)
		{
			iTotalLines += 2;
			dwGroup = 0;
		}
		else
		{
			iTotalLines++;
		}
		dwCount += 4;
		iGoal -= 4;
	}
	iTotalLines++;
}

// Test a number for the proper length of 13 characters.
// If not, we have to move the number to the right by 2
// and pad it with 2 spaces.
//.....................................................
VOID CheckOutTheNumber(LPBYTE lpNumber)
{
	TCHAR			szOurNumber[16];
	LPBYTE			lpszOurNumber = szOurNumber;

	if (lstrlen(lpNumber) == 11)
	{
		ZeroMemory(&szOurNumber,sizeof(szOurNumber));
		*lpszOurNumber = 0x20;
		lpszOurNumber++;
		*lpszOurNumber = 0x20;
		StringCbCat((LPTSTR)&szOurNumber,sizeof(szOurNumber),(LPCTSTR)lpNumber);
		CopyMemory(lpNumber,&szOurNumber,sizeof(szOurNumber));
	}
	else if (lstrlen(lpNumber) == 1)
	{
		*lpNumber = 0x20;
	}
}
